// ========================================
// SKRYPT DO IMPORTU NA SERWER
// Otwórz https://asmodev.com/proto/thief/kreator
// Otwórz konsolę (F12) i wklej cały ten kod
// ========================================

const API = {
    itm_add: 'design/api_add_item.php',
    loc_add: 'design/api_add_location.php',
};

async function jpost(url, data) {
    try {
        const r = await fetch(url, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams(data)
        });
        const t = await r.text();
        try { return JSON.parse(t); } catch { return { ok: false, raw: t }; }
    } catch (e) { return { ok: false, err: String(e) }; }
}

// PRZEDMIOTY (403 items)
const items = `abacus
abstract painting nebula
abstract painting planet
acoustic guitar
air filter
alarm clock
american whiskey
ancient stone
antique clock
antique coffee mill
antique horn
antique radio
antique table clock
antique wall clock
associate action points
atm hacking tool
audio system amp
audio system column
automatic lockpick
bank plan
basement key 108
bass guitar
bass guitar 2
baton
big grandfather clock
binoculars
black guitar
black package
blender
blowtorch
blt
blue guitar
bracelet gold
bracelet gold parts
bracelet silver
bracelet silver parts
brake disc
brake pads
briefcase explosives
bronze medal
cabinet key 203
calculator
candelabra
candle holder
candle stand
car assembly toolbox
car battery
car lock pickgun
car storage
cardboard box
cash register
catalytic
cheap blender
cheap landline phone
cheap radio
chess board
chimes
china vase
city painting
climbing gloves
clown mask
coffee machine
coffee machine black
colors painting
computer
computer five
cone vase
conf laptop
conf laptop locked
conference phone
copper figure
cowboy hat
cracked vase
creepy mask
crowbar
dark painting
decent ssd
decor statue
decorative vase
decorative vase 2
deer painting
dex camera
diamond earrings
DiamondEarrings
djembe
dog meat
DoorKey
double barrel
downtown painting
dragon statue
drawing tablet
drill
earth painting
electric guitar black
electric kettle
electric piano
electric toothbrush
end muffler
exhaust camshaft
exhaust manifold
expensive router
famous persons phone
female sculpture gold
five keyboard
five monitor
five mouse
five TV
five TV broken
flashlight
flyby drone
flyp smartphone
forklift key
frying pan
fuel rail
fuel tank
gamestation
gamestation 2
gamestation pad
gaming computer
gaming laptop
GateKey102
generator
generator belt
glasscutter
globe
god statute
gold bar
gold cash register
gold head
gold medal
GoldBar
golden dragon
golf cart
good projector
grandfathers clock
granite statue
green vase
gumball
hacking laptop
hackpda
halloween pumpkin
handheld cosmos
handheld juke
hard drive
haunted child mask
haunted mechanical doll
head statue
headphones noname
headphones noname1
headphones noname2
headphones noname3
headset
high end headphones
highend monitor
house decoration
imak
imak keyboard
imak mouse
intake camshaft
intake manifold
intercom
intro gate key
item plant
jewellery tools
kevlar clutch
key 101
key 101 main
key 102
key 102 gate
key 103
key 105 gate
key 107
key 107 cabinet
key 109
key 114
key 201 gate
key 206
key 2c cabinet
key 309 gate
key 666 chest
key police exit
keyboard
keyboard 2
keyboard 3
keyfob
knifeholder
knifeholder 2
lake painting
landline phone samlong
laser meter
leather briefcase
leather wallet
leather wallet black
lockpick
lockpick basic
low end laptop
lowcase tablet
M1879 revolver
m26 grenade
male skull
maracas
mayan statue
mecenas benc
mecenas benc rs
mecenas disc
mecenas sport wheel
mecenas wheel
medi smartphone
micro camera
microphone
microwave
microwave 2
middle muffler
modern landline phone
Money
Money150
Money30
Money50
Money500
monitor
monitor 2
monoblock laptop broken
motoloco phone
mouse
mouse 2
moviecam redlens
multimeter
museum plan
mysterious pyramid
nega coffee
neonbot drone
nexon camera
night goggles
ninledo console
noblesoft
noisy talkie
oil pan
old camcorder
old clock
old jewelry box
old table clock
old TV
orange vase
orderly tangle
ouija board
painting aqua
painting artistic sunset
painting autumn
painting autumn valley
painting blue
painting bond
painting bridge
painting butterfly
painting castle
painting cat
painting cockatoo
painting fruit tree
painting grudge
painting lighthouse
painting messy
painting new york
painting passage
painting purple winter
painting red
painting ships
painting sunset
painting triangles
painting volcano
painting waterfall
painting window
pc mastersoft
piano painting
pixar phone
plague doctor mask
plan tut
player hands
pot
printer
printer 3d
printer lp
projector
prospect car
prospect wheel
radio
radio set
receiver
record player
red toaster
regular wallet
remote camera
respirator
retro computer svm
retro music player
ripple tablet broken
rock statue
router
rover disc
rover rider
rover wheel
samlong tablet
samlong TV
sanny phone
sauce pan
sauce pan 2
scanner
selfmade gun
shock absorber
shovel
silver medal
skateboard chess
skateboard flame
skateboard skeleton
ski mask
skyeye drone
sleeping gas
small vase
smart speaker violet
spark plug wires
spark plugs
speaker
speaker 2
special shoes
spiral sphere
spirit level
spoons painting
sport air filter
sport brake caliper
sport brake disc
sport catalyst
stash key 110
steel teapot
steering rack
stethoscope
subwoofer
super TV
super TV 2
suspicious briefcase
synthesizer x16
table clock
table fan
table lamp
table lamp cyli
table lamp ikee
tape measure
teapot
telescope
thompson
throttles
thunderdrive
thunderdrive wheel
timing belt
toaster
toaster 2
tomahawk
top musicians recorder
torus knot
toy lobster
train painting
tranq dart
tranquilizer gun
transistor radio
transmission zp6
turbo intercooler
turbocharger
tv speaker
tv speakers
tv video player
tvremote
uphone2
uphone damaged
usb flash 16gb
usb flash 64gb
used clutch
vacuum cleaner
valley painting
vase
vintage telephone
vintage typewriter
vintage vixen
vixen wheel
voice recorder
vr set
walkie talkie
wall clock
wall clock 2
wall clock 3
wall tv five
wall tv zoni
warehouse plan
watch smithford
watch smithford silver
water pump
white vase
wifi adapter
wine creek
wine robert
wood coffin
wooden decor
work laptop
work laptop 3
xcube
xcube pad`.split('\n').map(x => x.trim()).filter(Boolean);

// LOKACJE (infinite capacity)
const locations = `Player hideout
Construction zone - 100
Jefferson's - 101
Abandoned house - 102
Wilson's shed - 103
Local junkyard - 104
George's store - 105
Colebrooke's - 106
Hardy's - 107
Anderson's - 108
Rockhold's - 109
Edward's - 110
Perry's - 111
Foster's - 112
Adley's - 113
Ward's villa - 114
Crazy Joe's pawnshop - 115
200
201
203
204
207
208`.split('\n').map(x => x.trim()).filter(x => x && !x.startsWith('#'));

// UMIEJĘTNOŚCI
const skills = `Lockpicking lvl1
Lockpicking lvl2
Marking
Dusting
Cleaning
De-rusting
Screwing
Hacking
Oiling
Polishing
Glueing
Box-opening
Painting
Unbending`.split('\n').map(x => x.trim()).filter(Boolean);

// IMPORT FUNCTION
async function importAll() {
    console.log('========================================');
    console.log('IMPORT STARTED');
    console.log('========================================');

    // Import items
    console.log(`\n📦 Importing ${items.length} items...`);
    let itemSuccess = 0, itemFail = 0;
    for (let i = 0; i < items.length; i++) {
        const name = items[i];
        const lp = i + 1;
        const res = await jpost(API.itm_add, { name, lp });
        if (res && res.ok) {
            itemSuccess++;
            localStorage.setItem('itemIcon:' + name, '🎒');
            localStorage.setItem('itemMeta:' + name, JSON.stringify({ lp }));
        } else {
            itemFail++;
        }
        if ((i + 1) % 50 === 0) {
            console.log(`  Progress: ${i + 1}/${items.length}...`);
        }
    }
    console.log(`✅ Items: ${itemSuccess} success, ${itemFail} failed`);

    // Import locations
    console.log(`\n🏠 Importing ${locations.length} locations (all infinite)...`);
    let locSuccess = 0, locFail = 0;
    for (let i = 0; i < locations.length; i++) {
        const name = locations[i];
        const lp = i + 1;
        const res = await jpost(API.loc_add, { name, capacity: 0, infinite: 1, lp });
        if (res && res.ok) {
            locSuccess++;
            localStorage.setItem('locIcon:' + name, '🏠');
            localStorage.setItem('locMeta:' + name, JSON.stringify({ infinite: true, capacity: 0, lp }));
        } else {
            locFail++;
        }
    }
    console.log(`✅ Locations: ${locSuccess} success, ${locFail} failed`);

    // Import skills
    console.log(`\n⚡ Importing ${skills.length} skills...`);
    const existingSkills = JSON.parse(localStorage.getItem('hero:skillDefs') || '[]');
    skills.forEach((name, i) => {
        existingSkills.push({ name, icon: '⚡', lp: existingSkills.length + i + 1 });
    });
    localStorage.setItem('hero:skillDefs', JSON.stringify(existingSkills));
    console.log(`✅ Skills: ${skills.length} added to localStorage`);

    console.log('\n========================================');
    console.log('✅ IMPORT COMPLETE!');
    console.log('========================================');
    console.log(`Items: ${itemSuccess}/${items.length}`);
    console.log(`Locations: ${locSuccess}/${locations.length}`);
    console.log(`Skills: ${skills.length}`);
    console.log('\n🔄 Refresh page (F5) to see changes!');
}

// RUN IMPORT
importAll();
